require( "quest/mg_doughball/convout.lua" );
require( "quest/activity_mode/activity_common.lua" );
combine_speech_tables();

round_num = 
{
	6, -- round one
	ACTIVITY_LEVEL_MAX, -- activity mode -- quest/activity_mode/activity_timer.lua
};

function get_activity_bonus_time(level)
	return MINUTES(3) + SECONDS(0) + SECONDS(5)*level*level;
end

initial_setup = true;

activity_done = false;
show_activity_text = false;

local attempt = 0;

local debug_visualisation = true;

-- could add player as an object but it's easier to keep track of the player's position by treating them as a special case
local objectInfo = 
{
	-- 1 = table
	{
		image = "table1";
	};
	-- 2 = exit
	{
		image = "exit";
	};
	-- 3 = doughball
	{
		image = "doughball";
	};
	-- 4 = table
	{
		image = "table2";
	};
	-- 5 = table
	{
		image = "table3";
	};

};

local collisionImages =
{
	"gridSquareOccupied",	-- 1
	"potplant",		-- 2
	"planter_left",		-- 3
	"planter_mid",		-- 4
	"planter_right",	-- 5
	"banquet_top_left",	--6
	"banquet_top_mid",	--7
	"banquet_top_right",	--8
	"banquet_mid_left",	--9
	"banquet_mid_mid",	--10
	"banquet_mid_right",	--11
	"banquet_bottom_left",	--12
	"banquet_bottom_mid",	--13
	"banquet_bottom_right",	--14
	"planter_vert_top",	--15
	"planter_vert_mid",	--16
	"planter_vert_bottom",	--17
	"pool_top_left",	--18
	"pool_top_mid",		--19
	"pool_top_right",	--20
	"pool_mid_left",	--21
	"pool_mid_mid",		--22
	"pool_mid_right",	--23
	"pool_bottom_left",	--24
	"pool_bottom_mid",	--25
	"pool_bottom_right",	--26
	"lounge_top",		--27
	"lounge_right",		--28
	"lounge_bottom",	--29
	"lounge_left",		--30
	"potplant_02",		--31

};


local doughballInfo = 
{
	image = "doughball";
};

local playerInfo = 
{
	image = "player";
};

local arrowInfo =
{
	{ image = "up", offset = { x = 0, y = 0 } };
	{ image = "down", offset = { x = 50, y = 0 } };
	{ image = "left", offset = { x = 100, y = 0 } };
	{ image = "right", offset = { x = 150, y = 0 } };	
};

local levels =
{
	-- round one
	{
		-- level_one = 
		{
			background_image = "level1";
			player_start = { x = 1, y = 1 };
			collision_layer = { 
							0,  0,  0, 27, 27, 27, 27, 27, 27, 27,  0,  0,  0, 
							0,  0,  0, 18, 19, 19, 20,  0,  0,  0,  0,  0,  0, 
							0,  0 , 0, 24, 25, 25, 26,  0,  0, 28,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0, 28,  0,  0, 28, 
							0,  0,  0 , 0,  0,  0,  0,  0,  0, 28,  0,  0, 28, 
							0,  0,  0,  0,  0,  0,  0,  0 , 0, 28,  0,  0, 28, 
							0,  0,  0, 18, 19, 19, 20,  0,  0, 28,  0,  0,  0, 
							0,  0,  0, 24, 25, 25, 26,  0,  0,  0,  0,  0,  0, 
							0,  0,  0, 29, 29, 29, 29, 29, 29, 29,  0,  0,  0
						};
			object_layer = 	{
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
							0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
						};	
		};
		-- level_two = 
		{
			background_image = "level2";
			player_start = { x = 13, y = 1 };
			collision_layer = { 
							27,27, 27, 27, 27, 27, 27, 27, 27, 27,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0, 28,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0, 28,  0,  0,  0, 
							15, 0,  0, 18, 19, 19, 20,  0,  0, 28,  0,  0,  0, 
							16, 0,  0, 21, 22, 22, 23,  0,  0,  0,  0,  0,  0, 
							16, 0,  0, 24, 25, 25, 26,  0,  0, 28,  0,  0,  0, 
							17, 0,  0,  0,  0,  0,  0,  0,  0, 28,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0, 28,  0,  0,  0, 
							0,  0,  0, 29, 29, 29, 29, 29, 29, 29,  0,  0,  0 
						};
			object_layer = 	{
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 
						};	
		};
		-- level_three = 
		{
			background_image = "level2";
			player_start = { x = 1, y = 1 };
			collision_layer = { 
							0,  0,  3,  4,  4,  4,  4,  4,  4,  4,  5,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  6,  8,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0, 12, 14,  0,  0, 
							0,  0,  6,  7,  7,  7,  7,  8,  0,  0,  0,  0,  0, 
							0,  0, 12, 13, 13, 13, 13, 14,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							6,  7,  8,  0,  0,  0,  0,  0,  6,  7,  8,  0,  0, 
							9, 10, 11,  0,  0,  0,  0,  0,  9, 10, 11,  0,  0, 
							12, 13, 14, 0,  0,  0,  0,  0, 12, 13, 14,  0,  0
						};
			object_layer = 	{
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 4, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2 
						};	
		};
		-- level_four = 
		{
			background_image = "level2";			
			player_start = { x = 13, y = 1 };
			collision_layer = { 
							0,  0,  0,  0,  0,  6,  8,  0,  0,  0,  0,  0,  0, 
							0,  0,  6,  8,  0, 12, 14,  0,  0,  6,  8,  0,  0, 
							0,  0, 12, 14,  0,  0,  0,  0,  0, 12, 14,  0,  0, 
							0,  0,  0,  0,  0,  0,  6,  8,  0,  0,  0,  0,  0, 
							0,  0,  0,  6,  8,  0, 12, 14,  0,  0,  6,  8,  0, 
							0,  0,  0, 12, 14,  0,  0,  0,  0,  0, 12, 14,  0, 
							6,  8,  0,  0,  0,  0,  0,  6,  8,  0,  0,  0,  0, 
							12, 14, 0,  0,  6,  8,  0, 12, 14,  0,  0,  0,  0, 
							0,  0,  0,  0, 12, 14,  0,  0,  0,  0,  0,  0,  0
						};
			object_layer = 	{
							0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 5, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 
						};	
		};
		-- level_five = 
		{
			background_image = "level2";
			player_start = { x = 1, y = 1 };
			collision_layer = { 
							0,  0,  0,  0,  0,  0,  0,  6,  7,  7,  8,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  12, 13, 13, 14, 0,  0, 
							0,  0,  6,  7,  7,  8,  0,  0,  0,  0,  0,  0,  0,  
							0,  0,  12, 13, 13, 14, 0,  0,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  6,  7,  7,  8,  0,  0, 
							15,  0,  6,  7,  7,  8,  0,  12, 13, 13, 14, 0,  0, 
							16,  0,  12, 13, 13, 14, 0,  0,  0,  0,  0,  0,  0,  
							16,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							17,  3,  4,  4,  4,  4,  4,  4,  4,  5,  0,  0,  0, 
						};
			object_layer = 	{
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2 
						};	
		};
		-- level_six = 
		{
			background_image = "level2";
			player_start = { x = 13, y = 1 };
			collision_layer = { 
							0,  0, 27, 27, 27, 27, 27, 27, 27, 27,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  18, 19, 20,  
							30, 0, 30,  0, 30,  0, 30,  0, 30,  0,  21, 22, 23, 
							30, 0, 30,  0, 30,  0, 30,  0, 30,  0,  21, 22, 23, 
							30, 0, 30,  0, 30,  0, 30,  0, 30,  0,  24, 25, 26, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  
							0,  0, 29, 29, 29, 29, 29, 29,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  2,  2,  0, 
						};
			object_layer = 	{
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 3, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 2 
						};	
		};

	},
	
	-- activity mode
	{
		-- level_one = 
		{
			background_image = "level1";
			player_start = { x = 1, y = 1 };
			collision_layer = { 
							0,  0,  0,  0,  0,  3,  4,  4,  4,  4,  4,  4,  5, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0,  6,  7,  8,  0,  0,  0,  0,  0,  0,  0,  0,  
							0,  0,  9, 10, 11,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0, 12, 13, 14,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  6,  7,  8,  0,  0,  0,  0, 
							15,  0,  0,  0,  0,  0,  9, 10, 11,  0,  0,  0,  0,  
							16,  0,  0,  0,  0,  0, 12, 13, 14,  0,  0,  0,  0, 
							17,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
						};
			object_layer = 	{
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
							0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
						};	
		};
		-- level_two = 
		{
			background_image = "level2";
			player_start = { x = 13, y = 1 };
			collision_layer = { 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0,  0, 27, 27, 27, 27, 27,  0,  0,  0,  0,  0, 
							0, 30,  0,  0,  0,  0,  0,  0,  0,  0, 28,  0,  0,  
							0, 30,  0, 18, 19, 19, 19, 20,  0,  0, 28,  0,  0, 
							0, 30,  0, 21, 22, 22, 22, 23,  0,  0, 28,  0,  0, 
							0, 30,  0, 24, 25, 25, 25, 26,  0,  0, 28,  0,  0, 
							0, 30,  0,  0,  0,  0,  0,  0,  0,  0, 28,  0,  0,  
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 28,  0,  0, 
							0,  0,  0, 29, 29, 29, 29, 29,  0,  0,  0,  0,  0, 
						};
			object_layer = 	{
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 
						};	
		};
		-- level_three = 
		{
			background_image = "level2";
			player_start = { x = 1, y = 1 };
			collision_layer = { 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0,  6,  7,  7,  7,  7,  7,  7,  7,  7,  8,  0, 
							0,  0,  9, 10, 10, 10, 10, 10, 10, 10, 10, 11,  0,  
							0,  0, 12, 13, 13, 13, 13, 13, 13, 13, 13, 14,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  6,  7,  7,  7,  7,  7,  8,  0,  0,  0,  0,  0, 
							0,  9, 10, 10, 10, 10, 10, 11,  0,  0,  0,  0,  0,  
							0, 12, 13, 13, 13, 13, 13, 14,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
						};
			object_layer = 	{
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2 
						};	
		};
		-- level_four = 
		{
			background_image = "level2";			
			player_start = { x = 13, y = 1 };
			collision_layer = { 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  6,  7,  8,  0,  0,  0, 
							0,  6,  7,  8,  0,  0,  0,  9, 10, 11,  0,  0,  0,  
							0,  9, 10, 11,  0,  0,  0, 12, 13, 14,  0,  0,  0, 
							0, 12, 13, 14,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  6,  7,  8,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  9, 10, 11,  0,  0,  0,  0,  0,  
							0,  0,  0,  0,  0, 12, 13, 14,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
						};
			object_layer = 	{
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 
						};	
		};
		-- level_five = 
		{
			background_image = "level2";
			player_start = { x = 1, y = 1 };
			collision_layer = { 
							0,  0,  0, 18, 19, 19, 19, 20,  0,  0,  0,  0,  0, 
							0,  0,  0, 24, 25, 25, 25, 26,  0, 28,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0, 28,  0,  0,  0,  
							0,  0,  0, 29, 29, 29, 29, 29,  0, 28,  0,  0,  0, 
							18, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0, 28,  0, 
							21, 23,  0,  0, 27, 27, 27, 27, 27,  0,  0, 28,  0, 
							21, 23,  0,  0,  0,  0,  0,  0,  0,  0,  0, 28,  0,  
							24, 26,  0,  0, 18, 19, 19, 19, 20,  0,  0,  0,  0, 
							0,  0,  0,  0, 24, 25, 25, 25, 26,  0,  0,  0,  0, 
						};
			object_layer = 	{
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2 
						};	
		};
		-- level_six = 
		{
			background_image = "level2";
			player_start = { x = 13, y = 1 };
			collision_layer = { 
							0,  0, 15,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0, 16,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0, 17,  0,  3,  4,  4,  4,  4,  5,  0, 15,  0,  
							0,  0,  0,  0,  3,  4,  4,  4,  4,  5,  0, 16,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 17,  0, 
							3,  4,  4,  4,  4,  5,  0,  6,  7,  8,  0,  0,  0, 
							3,  4,  4,  4,  4,  5,  0,  9, 10, 11,  0,  0,  0,  
							0,  0,  0,  0,  0,  0,  0, 12, 13, 14,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
						};
			object_layer = 	{
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 3, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 
							0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0 
						};	
		};
		-- level_seven = 
		{
			background_image = "level2";
			player_start = { x = 13, y = 1 };
			collision_layer = { 
							0,  0,  0,  3,  4,  4,  4,  4,  5,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							15,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  
							16,  0,  0,  3,  4,  4,  4,  4,  5,  0,  0,  0,  0, 
							16,  0,  0,  0,  0,  0,  0,  0,  0,  3,  4,  4,  5, 
							16,  0,  0,  0,  0,  0,  0,  0,  0,  3,  4,  4,  5, 
							16,  0,  3,  4,  4,  4,  4,  5,  0,  0,  0,  0,  0,  
							16,  0,  3,  4,  4,  4,  5,  0,  0,  0,  0,  0,  0, 
							17,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
						};
			object_layer = 	{
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 4, 
							0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 2, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 4 
						};	
		};
		-- level_eight = 
		{
			background_image = "level2";
			player_start = { x = 1, y = 1 };
			collision_layer = { 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0,  6,  7,  8,  0,  6,  7,  8,  0,  6,  7,  8, 
							0,  0,  9, 10, 11,  0,  9, 10, 11,  0,  9, 10, 11, 
							0,  0, 12, 13, 14,  0,  9, 10, 11,  0,  9, 10, 11, 
							0,  0,  0,  0,  0,  0,  9, 10, 11,  0,  9, 10, 11, 
							3,  4,  4,  4,  5,  0, 12, 13, 14,  0,  9, 10, 11, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 12, 13, 14,  
							0,  3,  4,  4,  4,  4,  4,  4,  5,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
						};
			object_layer = 	{
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 
							0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 
							0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2 
						};	
		};
		-- level_nine = 
		{
			background_image = "level2";
			player_start = { x = 13, y = 1 };
			collision_layer = { 
							0,  0,  0,  0,  0, 27, 27, 27, 27, 27,  0,  0,  0, 
							0,  0, 30,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0, 30,  0, 18, 19, 19, 19, 20,  0, 28,  0,  0,  
							0,  0, 30,  0, 21, 22, 22, 22, 23,  0, 28,  0,  0, 
							0,  0, 30,  0, 21, 22, 22, 22, 23,  0, 28,  0,  0, 
							0,  0, 30,  0, 24, 25, 25, 25, 26,  0, 28,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 28,  0,  0,  
							0,  0,  0,  0, 29, 29, 29, 29, 29,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
						};
			object_layer = 	{
							5, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 5, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 
							0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 
						};	
		};
		-- level_ten = 
		{
			background_image = "level2";
			player_start = { x = 1, y = 1 };
			collision_layer = { 
							0,  0,  0,  0,  0,  6,  8,  0,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0, 12, 14,  0,  0,  0,  0, 15,  0, 
							0,  0,  6,  8,  0,  0,  0,  0,  6,  8,  0, 16,  0,  
							0,  0, 12, 14,  0,  0,  0,  0, 12, 14,  0, 16,  0, 
							0,  0,  0,  0,  0,  6,  8,  0,  0,  0,  0, 17,  0, 
							6,  8,  0,  0,  0, 12, 14,  0,  0,  0,  0,  0,  0, 
							12,14,  0,  0,  0,  0,  0,  0,  0,  6,  8,  0,  0,  
							0,  0,  0,  6,  8,  0,  0,  0,  0, 12, 14,  0,  0, 
							0,  0,  0, 14, 14,  0,  0,  0,  0,  0,  0,  0,  0, 
						};
			object_layer = 	{
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 
							0, 3, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 
							0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 
						};	
		};
		
		-- level_eleven = 
		{
			background_image = "level2";
			player_start = { x = 13, y = 1 };
			collision_layer = { 
							0,  0,  0,  0,  0,  0,  0,  0, 15,  0,  0,  0,  0, 
							0, 15,  0,  0,  0,  0, 15,  0, 16,  0,  0,  0,  0,
							0, 16,  0,  0,  0,  0, 16,  0, 17,  0, 15,  0,  0,   
							0, 17,  0,  0, 15,  0, 17,  0,  0,  0, 16,  0,  0, 
							0,  0,  0,  0, 16,  0,  0,  0,  0,  0, 17,  0,  0, 
							0,  0,  0,  0, 17,  0,  0, 15,  0,  0,  0,  0,  0, 
							0,  0, 15,  0,  0,  0,  0, 16,  0,  0, 15,  0,  0,  
							0,  0, 16,  0,  0,  0,  0, 17,  0,  0, 16,  0,  0, 
							0,  0, 17,  0,  0,  0,  0,  0,  0,  0, 17,  0,  0, 
						};
			object_layer = 	{
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 
							0, 0, 0, 0, 1, 0, 0, 0, 0, 4, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							1, 4, 1, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 5, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 2, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 
						};	
		};
		-- level_twelve = 
		{
			background_image = "level2";
			player_start = { x = 13, y = 1 };
			collision_layer = { 
							0,   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,   0, 18, 19, 19, 19, 19, 19, 19, 20,  0,  0,  0, 
							30,  0, 21, 22, 22, 22, 22, 22, 22, 23,  0,  0, 28,  
							30,  0, 21, 22, 22, 22, 22, 22, 22, 23,  0,  0, 28, 
							30,  0, 24, 25, 25, 25, 25, 25, 25, 26,  0,  0, 28, 
							30,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 28, 
							30,  0, 29, 29, 29, 29, 29, 29, 29, 29, 29,  0, 28,  
							30,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 28, 
							0,   0,  0,  0, 29, 29, 29, 29, 29,  0,  0,  0,  0, 
						};
			object_layer = 	{
							0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 
							2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 
						};	
		};
		-- level_thirteen = 
		{
			background_image = "level2";
			player_start = { x = 13, y = 1 };
			collision_layer = { 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  6,  8,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0, 12, 14,  6,  7,  8,  0,  6,  7,  8,  0,  3,  5,  
							0,  0,  0,  9, 10, 11,  0,  9, 10, 11,  0,  0,  0, 
							0,  0,  0, 12, 13, 14,  0, 12, 13, 14,  6,  8,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 12, 14,  0, 
							0,  15,  0,  0,  0,  6,  7,  8,  0,  0,  0,  0,  0,  
							0,  17,  0,  0,  0, 12, 13, 14,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
						};
			object_layer = 	{
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 
							0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2 
						};	
		};
		-- level_fourteen = 
		{
			background_image = "level2";
			player_start = { x = 1, y = 1 };
			collision_layer = { 
							0,   0,  0,  0,  6,  7,  8,  6,  8,  6,  7,  7,  8, 
							0,   0,  0,  0,  9, 10, 11, 12, 14,  9, 10, 10, 11, 
							0,   0,  0,  0, 12, 13, 14,  0,  0,  9, 10, 10, 11,  
							0,   0,  0,  0,  0,  0,  0,  0,  0, 12, 13, 13, 14, 
							15,  6,  7,  7,  7,  7,  8,  0,  0,  0,  0,  6,  8, 
							16, 12, 13, 13, 13, 13, 14,  0,  0,  0,  0, 12, 14, 
							16,  0,  0,  0,  0,  0,  0,  0,  0,  6,  7,  7,  8,  
							16,  0,  0,  0,  0,  0,  0,  0,  0,  9, 10, 10, 11, 
							17,  3,  4,  4,  4,  4,  4,  4,  5, 12, 13, 13, 14, 
						};
			object_layer = 	{
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 1, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 
							0, 2, 0, 4, 0, 5, 0, 5, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 
						};	
		};
		-- level_fifteen = 
		{
			background_image = "level2";
			player_start = { x = 13, y = 1 };
			collision_layer = { 
							6,   7,  8, 15,  6,  8,  15,  6,  8, 15,  0,  0,  0, 
							9,  10, 11, 16,  9, 11,  16,  9, 11, 16,  0,  0,  0, 
							9,  10, 11, 16, 12, 14,  16, 12, 14, 17,  0,  0,  0,  
							12,  13, 14, 17,  0,  0,  17,  0,  0,  0,  0,  0,  0, 
							0,   0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0, 
							0,   0,  0,  0,  0,  0,  15,  6,  8, 15,  6,  7,  8, 
							0,   0,  0, 15,  6,  8,  16,  9, 11, 16,  9, 10, 11,  
							0,   0,  0, 16,  9, 11,  16,  9, 11, 16,  9, 10, 11, 
							0,   0,  0, 17, 12, 14,  17, 12, 14, 17, 12, 13, 14, 
						};
			object_layer = 	{
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 1, 0, 
							0, 5, 0, 0, 4, 0, 0, 0, 1, 0, 0, 0, 0, 
							0, 1, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 
						};	
		};

		-- level_sixteen = 
		{
			background_image = "level2";
			player_start = { x = 1, y = 1 };
			collision_layer = { 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0,  0, 18, 19, 20,  0,  0,  6,  7,  7,  8,  0, 
							0, 30,  0, 21, 22, 23,  0,  0, 12, 13, 13, 14,  0,  
							0, 30,  0, 21, 22, 23,  0,  0,  0,  0,  0,  0,  0, 
							0, 30,  0, 21, 22, 23,  0,  0,  6,  7,  8,  0,  0, 
							0, 30,  0, 21, 22, 23,  0,  0,  9, 10, 11,  0,  0, 
							0,  0,  0, 24, 25, 26,  0,  0,  9, 10, 11,  0,  0,  
							0,  0,  0,  0,  0,  0,  0,  0, 12, 13, 14,  0,  0, 
							0, 29, 29, 29, 29,  0,  0,  0,  0,  0,  0,  0,  0, 
						};
			object_layer = 	{
							0, 0, 0, 0, 5, 0, 0, 0, 0, 1, 0, 0, 0, 
							0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							1, 0, 0, 0, 0, 0, 5, 5, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 
							1, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 
						};	
		};
		-- level_seventeen = 
		{
			background_image = "level2";
			player_start = { x = 1, y = 1 };
			collision_layer = { 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
						};
			object_layer = 	{
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2 
						};	
		};
		-- level_eighteen = 
		{
			background_image = "level2";
			player_start = { x = 1, y = 1 };
			collision_layer = { 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
						};
			object_layer = 	{
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2 
						};	
		};
		-- level_nineteen = 
		{
			background_image = "level2";
			player_start = { x = 1, y = 1 };
			collision_layer = { 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
						};
			object_layer = 	{
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2 
						};	
		};
		-- level_twenty = 
		{
			background_image = "level2";
			player_start = { x = 1, y = 1 };
			collision_layer = { 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
							0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
						};
			object_layer = 	{
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
							0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2 
						};	
		};
	},
};

local current_level = 
{
	player_start = { };
	collision_layer = { };
	object_layer = 	{ };	
};

local grid = { }; -- for debugging only?
local objects = { };
--local background = nil;

local player = 
{
	object = nil;
	pos = {  };
};

local doughball = nil;

local gridFormatInfo = 
{
	grid_width = 13,
	grid_height = 9,
	screen_x_offset = 75,
	screen_y_offset = 25
};

local gridSquare = 
{
	width = 50,
	height = 50,
	image = "gridSquare", -- for debugging only?
	imageOccupied = "gridSquareOccupied",
	imageHighlight = "gridSquareHighlight"
};

function get_direction_image( pos )
	local player_pos = Position(player.pos.x, player.pos.y);
	
	if pos.x < player_pos.x then
		return "ship_left_arrow";
	elseif pos.x > player_pos.x then
		return "ship_right_arrow";
	elseif pos.y < player_pos.y then
		return "ship_up_arrow";
	else
		return "ship_down_arrow";
	end
end

function reset()	
	activity_done = false;
	current_level = 
	{
		player_start = { };
		collision_layer = { };
		object_layer = 	{ };	
	};
	for i = 1, gridFormatInfo["grid_height"] * gridFormatInfo["grid_width"] do
		if ( debug_visualisation == true ) then
			grid[i]:Expire();
		end
		if ( objects[i] ~= nil ) then
			objects[i]:Expire();
		end
	end
	player.object:Expire();
	--background:Expire();
	grid = { }; -- for debugging only?
	objects = { };
	player = 
	{
		object = nil;
		pos = {  };
	};	
end

function get_arrow_item_spec(_name, _image, pos, direction ) 
	return
	{
		name = _name;
		halo = "arrow";
		gfx = { image = _image };
	
		command = function(actor)
			actor:SetDepthValue(1);
			actor:JumpToPoint( pos );
			actor:SetPointAtCursor("cursor");
			actor:SetAlpha(1);
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				y = 30,
				x = -15,
				w = 90,
				h = 25,
				bubble = false,
				outline_size = 0,
				font = "fonts/garamondpremierpro.mvec"; 
				anchor = ANCHOR.CENTER
			};
			actor.direction = direction;
			actor.on_click = function()
				if ( activity_done ) then
					return;
				end
				if ( direction == 1 ) then
					Move( { x = 0, y = -1 } );
				elseif ( direction== 2 ) then
					Move( { x = 0, y = 1 } );
				elseif ( direction== 3 ) then		
					Move( { x = -1, y = 0 } );					
				elseif ( direction== 4 ) then
					Move( { x = 1, y = 0 } );
				end
			end;
		end;
	}
end

function on_key( key )
	if ( activity_done ) then
		return
	end
	
        if key == DFKEY.ARROW_UP then
		Move( { x = 0, y = -1 } );
        elseif key == DFKEY.ARROW_DOWN then
		Move( { x = 0, y = 1 } );
	elseif key == DFKEY.ARROW_LEFT then
		Move( { x = -1, y = 0 } );
	elseif key == DFKEY.ARROW_RIGHT then
		Move( { x = 1, y = 0 } );
        end
end

function Move( move )
	local dest = { x = player.pos.x + move.x, y = player.pos.y + move.y };
	
	set_player_direction(dest);
	play_footstep_sound();
	
	-- bounds check
	if ( PointInRectangle( dest, { tlx = 1, tly = 1, brx = gridFormatInfo.grid_width, bry = gridFormatInfo.grid_height } ) == false ) then
		draw_level();
	elseif ( ObjectAt( Index( dest.x, dest.y ) ) == false or current_level.object_layer[Index( dest.x, dest.y )] == 2 ) then
		-- immovable collision check	
		player.pushing = false;
		if ( CollisionAt( Index( dest.x, dest.y ) ) == true ) then
		else
			-- no object to push so just move
			player.pos = dest;
		end
		draw_level();
	else -- check if can push object
		local objectdest = { x = dest.x + move.x, y = dest.y + move.y };
		player.pushing = true;
		-- bounds check
		if ( PointInRectangle( objectdest, { tlx = 1, tly = 1, brx = gridFormatInfo.grid_width, bry = gridFormatInfo.grid_height } ) == false ) then
			draw_level();
		elseif ( ObjectAt( Index( objectdest.x, objectdest.y ) ) == false ) then
			-- immovable collision check	
			if ( CollisionAt( Index( objectdest.x, objectdest.y ) ) == true ) then
			else
				PlayObjectMoveSound( Index( dest.x, dest.y ) );
				-- push object
				
				if current_level.object_layer[Index( dest.x, dest.y )] == 3 then
					player.doughmove = true;
				end
				
				SwapObjects( Index( dest.x, dest.y ), Index( objectdest.x, objectdest.y ) );	
				-- move player
				player.pos = dest;
			end
			-- update graphics
			draw_level();
		elseif ( current_level.object_layer[Index( dest.x, dest.y )]  == 3 and current_level.object_layer[Index( objectdest.x, objectdest.y )]  == 2 ) then
			-- puzzle completed
			-- move doughball onto exit
			SwapObjects( Index( dest.x, dest.y ), Index( objectdest.x, objectdest.y ) );
			objects[Index( dest.x, dest.y )]:Expire();
			objects[Index( dest.x, dest.y )] = nil;
			current_level.object_layer[Index( dest.x, dest.y )] = 0;		
			-- move player
			player.pos = dest;
			-- update graphics
			draw_level();
			activity_done = true;
			scene.FLO:StartProc(activity_passed);
		end
	end			
end

function SwapObjects( i, j )
	local objectItem = objects[j];
	objects[j] = objects[i];
	objects[i] = objectItem;
	local object = current_level.object_layer[j];
	current_level.object_layer[j] = current_level.object_layer[i];
	current_level.object_layer[i] = object;
end

function PointInRectangle( point, rectangle )
	if ( point.x < rectangle.tlx ) then
		return false;
	elseif ( point.x > rectangle.brx ) then
		return false;
	elseif ( point.y < rectangle.tly ) then
		return false;
	elseif ( point.y > rectangle.bry ) then
		return false;
	end
	return true;
end

function spawn_grid()  -- for debugging only?
	for i = 1, gridFormatInfo["grid_height"] do
		for j = 1, gridFormatInfo["grid_width"] do
			local gridSquare_item_spec = get_gridSquare_item_spec( "gridSquare" .. tostring( game:Get("mg_doughball_activity_num") ) .. tostring(j) .. tostring(i) .. tostring(attempt), Position( j, i ), j, i );
			table.insert( grid, Index( j, i ), scene:Spawn(gridSquare_item_spec));
		end
	end
end

function Index( x, y )
	local i = ( ( (y - 1) * gridFormatInfo["grid_width"] ) + x );
	return i;
end

function Position( x, y )
	local xPos = gridFormatInfo["screen_x_offset"] + ( x - 1 ) * gridSquare.width;
	local yPos = gridFormatInfo["screen_y_offset"] + ( y - 1 ) * gridSquare.height;
	return { x = xPos, y = yPos };
end

function get_gridSquare_item_spec(_name, pos, _xIndex, _yIndex) -- for debugging only?
	return
	{
		name = _name;
		halo = "arrow";
		gfx = { image = gridSquare.image };
	
		command = function(actor)
			actor:SetDepthValue(2);
			actor:JumpToPoint( pos );
			actor:SetPointAtCursor("cursor");
			actor:SetAlpha(1);
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				y = 30,
				x = -15,
				w = 90,
				h = 25,
				bubble = false,
				outline_size = 0,
				font = "fonts/garamondpremierpro.mvec"; 
				anchor = ANCHOR.CENTER
			};
			actor.point_at_fn = function(actor, enter)				
				if ( activity_done ) then
					return;
				end				
				if ( enter and CanMove( _xIndex, _yIndex ) == true ) then
					if ObjectAt( Index( _xIndex, _yIndex ) ) then
						actor:LoadImage( gridSquare.imageHighlight );
					else
						local dir_image = get_direction_image( pos );
						actor:LoadImage(dir_image);
					end
					
					actor:SetPointAtCursor("cursor_glow");
				else
					actor:SetPointAtCursor("cursor");
					--draw_level();
					actor:LoadImage( gridSquare.image );
				end				
			end;
			actor.on_click = function()
				if ( activity_done ) then
					return;
				end				
				if ( CanMove( _xIndex, _yIndex ) == true ) then					
					local move = GetMoveFromDest( { x = _xIndex, y = _yIndex } );
					if ( math.abs( move.x ) + math.abs( move.y ) == 1 ) then
						actor:SetPointAtCursor("cursor");
						Move( move );
					end
				end
			end;
		end;
	}
end

function GetMoveFromDest( dest )
	local move = { x = dest.x - player.pos.x, y = dest.y - player.pos.y };
	return move;
end

function CanMove( x, y )
	local dest = { x = x, y = y };	
	-- is the square close enough to the player
	local move = GetMoveFromDest( dest ); 
	if ( math.abs( move.x ) + math.abs( move.y ) ~= 1 ) then
		return false;
	end
	-- bounds check
	if ( PointInRectangle( dest, { tlx = 1, tly = 1, brx = gridFormatInfo.grid_width, bry = gridFormatInfo.grid_height } ) == false ) then
		return false;
	end
	if ( ObjectAt( Index( dest.x, dest.y ) ) == false or current_level.object_layer[Index( dest.x, dest.y )] == 2 ) then
		-- immovable collision check	
		if ( CollisionAt( Index( dest.x, dest.y ) ) == true ) then
			return false;
		end
		-- no object to push so just move
		return true;
	else -- check if can push object		
		local objectdest = { x = dest.x + move.x, y = dest.y + move.y };
		-- bounds check
		if ( PointInRectangle( objectdest, { tlx = 1, tly = 1, brx = gridFormatInfo.grid_width, bry = gridFormatInfo.grid_height } ) == false ) then			
			return false;
		end
		if ( ObjectAt( Index( objectdest.x, objectdest.y ) ) == false ) then
			-- immovable collision check	
			if ( CollisionAt( Index( objectdest.x, objectdest.y ) ) == true ) then				
				return false;
			end
			-- push object
			return true;
		elseif ( current_level.object_layer[Index( dest.x, dest.y )]  == 3 and current_level.object_layer[Index( objectdest.x, objectdest.y )]  == 2 ) then
			return true;
		end
	end	
	return false; -- just in case
end

function spawn_level(actor)
	local round = game:Get("mg_doughball_activity_round");
	local activity_num = game:Get("mg_doughball_activity_num");
	local activity_mode = game:Get("activity_mode") == 1;
	
	if activity_mode then
		activity_num = game:Get("activity_mode_level");
		round = table.getn(round_num);
	end
	
	sfx:PlaySFX("audio/sfx/dough_level_begin");

	local activity_data = levels[round][activity_num];
	if activity_data then
		--local object_item_spec = get_object_item_spec( "background" .. tostring( game:Get("mg_doughball_activity_num") ) .. tostring(attempt), activity_data.background_image, { x = 0, y = 0 } );
		--background = scene:Spawn(object_item_spec);
		--background:SetDepthValue(0);
		current_level.player_start.x = activity_data.player_start.x;
		current_level.player_start.y = activity_data.player_start.y;
		for j = 1, gridFormatInfo.grid_height * gridFormatInfo.grid_width do
			current_level.collision_layer[j] = activity_data.collision_layer[j];
			current_level.object_layer[j] = activity_data.object_layer[j];	
		end
	end
	spawn_objects();
	spawn_player();
end

function spawn_player()
	local pos = current_level.player_start;
	local player_item_spec = get_object_item_spec( "player" .. tostring( game:Get("mg_doughball_activity_num") ) .. tostring(attempt), playerInfo.image, Position( pos.x, pos.y ) );
	player.object = scene:Spawn(player_item_spec);
	player.pos = pos;
	player.direction = "right";
	player.moving = false;
	player.step = 0;
end

function spawn_objects()
	for i = 1, gridFormatInfo.grid_height do
		for j = 1, gridFormatInfo.grid_width do
			local object = current_level.object_layer[Index( j, i )];
			local object_instance = nil;
			if ( object ~= 0 ) then
				local object_item_spec = get_object_item_spec( "object" .. tostring( game:Get("mg_doughball_activity_num") ) ..tostring(j) .. tostring(i) .. tostring(attempt), objectInfo[object].image, Position( j, i ) );
				object_instance = scene:Spawn(object_item_spec);
				
				if object == 3 then -- we want to keep a hold of our dough ball object
					doughball = object_instance;
				end
			else
				local object_item_spec = get_object_item_spec( "object" .. tostring( game:Get("mg_doughball_activity_num") ) ..tostring(j) .. tostring(i) .. tostring(attempt), "", Position( j, i ) );
				object_instance = scene:Spawn(object_item_spec);
			end

			table.insert( objects, Index( j, i ), object_instance);				
		end				
	end
end

function get_object_item_spec(_name, _image, pos ) 
	return
	{
		name = _name;
		-- halo = gridSquare.image;
		gfx = { image = _image };
	
		command = function(actor)
			actor:SetDepthValue(3);
			actor:JumpToPoint( pos );
			actor:SetPointAtCursor("cursor");
			actor:SetAlpha(1);
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				y = 30,
				x = -15,
				w = 90,
				h = 25,
				bubble = false,
				outline_size = 0,
				font = "fonts/garamondpremierpro.mvec"; 
				anchor = ANCHOR.CENTER
			};
		end;
	}
end

function draw_level()
	if ( debug_visualisation == true ) then
		draw_grid(); -- debug only?
	end
	draw_objects();
	draw_player();
end

function play_footstep_sound()
	local footstep_sound = "";
	
	if player.step == 1 then
		footstep_sound = "audio/sfx/footstep_right" .. math.random(1,2);
	else
		footstep_sound = "audio/sfx/footstep_left" .. math.random(1,2);
	end
	
	sfx:PlaySFX(footstep_sound);
end

function draw_player()	
	local playerImage = "";
	
	if player.moving then
		if player.pushing then
			playerImage = "flo_push_" .. player.direction .. tostring(player.step);
		else
			playerImage = "flo_walk_" .. player.direction .. tostring(player.step);
		end
		
		--play_footstep_sound();
	else
		playerImage = "flo_face_" .. player.direction;
	end
	
	if player.doughmove then
		if player.doughstep == 1 then
			player.doughstep = 2;
		else
			player.doughstep = 1;
		end
		
		if player.direction == "up" or player.direction == "down" then
			doughball:LoadImage("dough_roll_vertical_" .. player.doughstep);
		else
			doughball:LoadImage("dough_roll_horizontal_" .. player.doughstep);
		end
		player.doughmove = false;
	end
	
	player.object:LoadImage(playerImage);
	
	player.object:JumpToPoint( Position( player.pos.x, player.pos.y ) );
end

function draw_objects()
	for i = 1, gridFormatInfo.grid_height do
		for j = 1, gridFormatInfo.grid_width do
			local object = objects[Index( j, i )];
			if ( object ~= nil ) then
				object:JumpToPoint( Position( j, i ) );
			end
		end
	end
end

function draw_grid()
	for i = 1, gridFormatInfo.grid_width * gridFormatInfo.grid_height do
		if ( CollisionAt( i ) ) then
			grid[i]:LoadImage( gridSquare.image );
			if objects[i] then
				objects[i]:LoadImage( collisionImages[current_level.collision_layer[i]] );
			end
		else
			grid[i]:LoadImage( gridSquare.image );
		end		
	end
end

function set_player_direction(dest)
	player.moving = true;

	if player.pos.x > dest.x then
		player.direction = "left";
	elseif player.pos.x < dest.x then
		player.direction = "right";
	elseif player.pos.y > dest.y then
		player.direction = "up";
	elseif player.pos.y < dest.y then
		player.direction = "down";
	end
	
	if player.step == 1 then
		player.step = 2;
	else
		player.step = 1;
	end
	
	scene.MOVE_TIMER:StartProc(player_move_timeout);
end

function CollisionAt( i )
	if ( current_level.collision_layer[i] + current_level.object_layer[i]  ~= 0 ) then
		return true;
	elseif ( i == Index( player.pos.x, player.pos.y ) ) then
		return true;
	end
	return false;
end

function ObjectAt( i )
	if ( current_level.object_layer[i]  ~= 0 ) then
		return true;
	elseif ( i == Index( player.pos.x, player.pos.y ) ) then
		return true;
	end
	return false;
end

function PlayObjectMoveSound( i )
	if current_level.object_layer[i] == 1 or current_level.object_layer[i] == 4 or current_level.object_layer[i] == 5 then
		sfx:PlaySFX("audio/sfx/dough_obstacle");
	elseif current_level.object_layer[i] == 3 then
		sfx:PlaySFX("audio/sfx/dough_roll");
	end
end

function setup_activity()
	local activityNum = game:Get("mg_doughball_activity_num");
	local activityRound = game:Get("mg_doughball_activity_round");
	local activityMode = game:Get("activity_mode") == 1;
	
	if activityMode then
		activityNum = game:Get("activity_mode_level");
		activityRound = table.getn(round_num);
	end
		
	attempt = attempt + 1;
	
	if initial_setup then
		if show_activity_text == true then
			scene:Spawn(round_num_spec);
			scene:Spawn(activity_num_spec);
			scene:Spawn(activity_title_spec);
		end
		initial_setup = false;
		coroutine.yield(RESUME.NOW);
	else
		reset();	
	end
	
	if show_activity_text == true then
		scene.ACTIVITY_NUM:SayRaw(scene:grabstring("activity") .. " " .. tostring(activityNum));
		scene.ROUND_NUM:SayRaw(scene:grabstring("round") .. " " .. tostring(activityRound));
	end
	
	if not activityMode then
		if activityNum == 1 and activityRound == 1 then
			help_panel_say_raw(scene:grabstring("tutorial_1"));
		else
			help_panel_say_raw(scene:grabstring("help_" .. tostring(activityRound) .. "_" .. tostring(activityNum)));
		end
	end
		
	spawn_level();
	
	if not scene.RESET_ACTIVITY_BUTTON then
		spawn_button(reset_activity_button_spec);
	end
	
	if ( debug_visualisation == true ) then
		spawn_grid(); -- for debugging only?	
	end
	draw_level();
end;

function next_activity(flo)
	local activityNum = game:Get("mg_doughball_activity_num");
	local activityRound = game:Get("mg_doughball_activity_round");
	local roundComplete = activityNum == 1; -- on next round
	local activityMode = game:Get("activity_mode") == 1;
	
	if not activityMode and roundComplete then	
		scene:SetFadeTarget { a = 1, r = 0, g = 0, b = 0 };
		scene:SetFadeSpeed(0.05);
		scene:SetMusicVolumeSpeed(0.05);
		wait_fade();

		sfx:SetMusic("audio/music/music_delivery_movies.ogg", true);
		scene:DisplayFlash("flash/closingmovie2_intro.swf");
		wait_subscene();	
		
		game:EarnAward("avenue-flo_finish");
		game:Set("game_just_over", 1);
		scene:GameOver();
	else
		if not activityMode then
			scene.NEXT_ACTIVITY_BUTTON:Expire();
		end
		
		if IsCheatMode() then
			if not activityMode then
				spawn_button(pass_activity_button_spec);
				--spawn_button(fail_activity_button_spec);
			end
		end
		
		if activityMode then
			spawn_button(start_button_spec);
			move_actor_y(scene.START_BUTTON, -hud_lower_offset);
			spawn_button(back_button_spec);
			move_actor_y(scene.BACK_BUTTON, -hud_lower_offset);
		else
			spawn_button(hint_button_spec);
			move_actor_y(scene.HINT_BUTTON, -hud_lower_offset);
		end
		
		if not activityMode then
			-- load new puzzle		
			setup_activity();
		else
			kill_activity_timer();
		end
	end
end;

function activity_passed(flo)
	stop_activity_timer(); -- quest/activity_mode/activity_timer.lua
	local activityNum = game:Get("mg_doughball_activity_num");
	local activityRound = game:Get("mg_doughball_activity_round");
	local roundComplete = activityNum == round_num[activityRound];
	local activityMode = game:Get("activity_mode") == 1;
	
	scene.RESET_ACTIVITY_BUTTON:Expire();
	
	if IsCheatMode() then
		scene.PASS_ACTIVITY_BUTTON:Expire();
		
		--if not activityMode then
		--	scene.FAIL_ACTIVITY_BUTTON:Expire();
		--end
	end
	
	if not activityMode then
		scene.HINT_BUTTON:Expire();
	else
		scene.BACK_BUTTON:Expire();
	end
	
	if not activityMode then
		spawn_button(next_activity_button_spec);
		scene.NEXT_ACTIVITY_BUTTON:StartProc(pulse_actor);
		
		help_panel_say_raw(
			scene:grabstring("finished_" .. tostring(activityRound) .. "_" .. tostring(activityNum)));
		
		if roundComplete then	
			if activityRound == 1 then -- only one round
				game:Set("mg_doughball_activity_round", 2);
				game:Set("mg_doughball_activity_num", 1);
			end
		else
			game:Set("mg_doughball_activity_num", activityNum + 1);
		end
	end
	
	-- save progress
	-- we're not saving our progress if the round is complete, as this will take us to an invalid screen
	if activityMode or not roundComplete then
		game:SaveGame();
	end
	
	spawn_activity_complete_text("activity_complete_text", "audio/sfx/dough_level_complete");
	coroutine.yield(RESUME.ON_SIGNAL);
	
	if activityMode then
		activityNum = game:Get("activity_mode_level");
		activityRound = table.getn(round_num);
		roundComplete = activityNum == round_num[activityRound];
		
		--if roundComplete then
		--	game:EarnAward("avenue-flo_doughballwrangler");
		--end
	
		show_activity_results();
	end
end;

function fail_activity(flo)
	-- display message of some sort
	setup_activity();
end;

function reset_activity(flo)
	fail_activity(flo);
end

flo_spec =
{
	name = "FLO";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
};

activity_title_spec = 
{
	name = "ACTIVITY_TITLE";
	
	command = function(actor)
		actor:JumpToPoint { x = 300, y = 10 };
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			y = 19,
			x = 5,
			w = 250,
			h = 50,
			lineheight = 40,
			bubble = false,
			outline_size = 0,
			font = "fonts/garamondpremierpro.mvec"; 
			anchor = ANCHOR.CENTER
		};
		actor:SayRaw(scene:grabstring("activity_title"));
	end;
};

round_num_spec = 
{
	name = "ROUND_NUM";
	
	command = function(actor)
		actor:JumpToPoint { x = 300, y = 60 };
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			y = 19,
			x = 5,
			w = 250,
			h = 50,
			lineheight = 30,
			bubble = false,
			outline_size = 0,
			font = "fonts/garamondpremierpro.mvec"; 
			anchor = ANCHOR.CENTER
		};
	end;
};

activity_num_spec = 
{
	name = "ACTIVITY_NUM";
	
	command = function(actor)
		actor:JumpToPoint { x = 300, y = 120 };
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			y = 19,
			x = 5,
			w = 250,
			h = 50,
			lineheight = 30,
			bubble = false,
			outline_size = 0,
			font = "fonts/garamondpremierpro.mvec"; 
			anchor = ANCHOR.CENTER
		};
	end;
};

function pass_activity(flo)
	flo:StartProc(activity_passed);
end

function go_back(flo)
	kill_help_panel();
	goto_scene(flo, "m1_dress");
end

move_timer_spec = 
{
	name = "MOVE_TIMER";
};

function player_move_timeout(timer)
	delay(60);
	player.moving = false;
	draw_player();
end

function spawn_water()
	local water_dimensions = { x = 256, y = 256 };
	local water_grid = { x = 3, y = 4 };
	
	for i = 0, water_grid.x do
		for j = 0, water_grid.y do
			local water_pos = { x = water_dimensions.x * i, y = water_dimensions.y * j };
			spawn_water_bg("WATER_BG" .. i .. "_" .. j, water_pos);
			spawn_water_anim("WATER_ANIM_" .. i .. "_" .. j, water_pos);
		end
	end
end

function spawn_water_bg(_name, _pos)
	return scene:Spawn
		{
			name = _name;
			gfx = { image = "water_bkgd" };
			
			command = function(actor)
				actor:SetDepthValue(0);
				actor:JumpToPoint(_pos);
			end;
		};
end

function spawn_water_anim(_name, _pos)
	return scene:Spawn
		{
			name = _name;
			gfx = { anim = "anim/mg_doughball/water" };
			
			command = function(actor)
				actor:SetDepthValue(0);
				actor:JumpToPoint(_pos);
				actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
				actor:PlayAnim("Water");
			end;
		};
end

local skip_intro = 0; -- handle intro skip

function setup_intro()
	scene:Spawn(ship_deck_spec);
	scene:Spawn(ship_front_spec);
	scene.SHIP_DECK:JumpToPoint { x = 0, y = 600 };
	scene:Spawn(intro_skip_spec);
end

function do_intro()
	local des_dist = 600;
	local speed = 2;
	local cur_dist = 0;
	
	while cur_dist < des_dist do
		move_actor_y(scene.SHIP_FRONT, -speed);
		move_actor_y(scene.SHIP_DECK, -speed);
		cur_dist = cur_dist + speed;
		delay(1);
		
		if skip_intro == 1 then
			scene.SHIP_DECK:JumpToPoint { x = 0, y = 0 };
			scene.SHIP_FRONT:JumpToPoint { x = 0, y = -des_dist };
			break;
		end
	end
	
	scene.SHIP_FRONT:Expire();
end

ship_front_spec = 
{
	name = "SHIP_FRONT";
	gfx = { image = "ship_front" };
	
	command = function(actor)
		actor:SetDepthValue(1);
	end
};

ship_deck_spec = 
{
	name = "SHIP_DECK";
	gfx = { image = "background" };
	
	command = function(actor)
		actor:SetDepthValue(1);
	end
}

intro_skip_spec = 
{
	name = "INTRO_SKIP";
	
	command = function(actor)
		coroutine.yield(RESUME.ON_CLICK);
		skip_intro = 1;
	end
}

hint_button_spec = 
{
	name = "HINT_BUTTON";
	text = "hint";
	halo = "quest/objects/button_thin";
	position = { x = 588, y = 530+hud_lower_offset };
	image = "buttons/button_thin";
	rolloversound = "audio/sfx/button_rollover";
	clicksound = "audio/sfx/buttonclick";
	depth = 50;
	say_spec =
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			color_over = { a = 1, r = 0, g = 0, b = 0 },
			y = 11,
			x = 0,
			w = 110,
			h = 20,
			bubble = false,
			lineheight = 17,
			outline_size = 0,
			font = "fonts/franklingothic_demicond.mvec"; 
			anchor = ANCHOR.CENTER
		};
	
	on_click = function(flo, actor)
		help_panel_say_raw(scene:grabstring("hint_1_" .. tostring(game:Get("mg_doughball_activity_num"))));
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/music_activity2.ogg", true);
		scene:SetRoomScale(300, 550, 0.7, 1.1);	--topline, bottomline, topscale, bottomscale
		delay(1); -- so any variables can be set properly (i.e. activity_mode)
		local activityMode = game:Get("activity_mode") == 1;
		game:ClearInvUsage();
		
		spawn_water();
		
		-- set up for initial play
		if game:Get("mg_doughball_activity_num") < 1 then
			game:Set("mg_doughball_activity_num", 1);
		end
		
		if game:Get("mg_doughball_activity_round") < 1 then
			game:Set("mg_doughball_activity_round", 1);
		end
		
		-- unlock dough ball in activity mode
		if game:Get("dough_ball_unlocked") < 1 then
			game:Set("dough_ball_unlocked", 1);
			game:Set("activity_unlocked", 1);
		end
		
		if game:Get("mg_doughball_activity_num") == 1 or (activityMode and game:Get("activity_mode_level") == 1) then
			setup_intro();
		else
			scene:Spawn(ship_deck_spec);
		end
		
		fade_scene_up(true);
		lower_hud();
		
		if activityMode then
			spawn_button(start_button_spec);
		else
			spawn_button(hint_button_spec);
		end
		
		spawn_help_panel();
		
		if not activityMode then
			scene.BACK_BUTTON:Expire();
		end
		
		if IsCheatMode() then
			-- testing data
			if not activityMode then
				spawn_button(pass_activity_button_spec);
				--spawn_button(fail_activity_button_spec);
			end
		end
		
		if game:Get("mg_doughball_activity_num") == 1 or (activityMode and game:Get("activity_mode_level") == 1) then
			do_intro();
		end
		
		if not activityMode then
			setup_activity();
		else
			help_panel_activity_mode_intro();
		end
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces" -- load pieces
	};
	
	bg_image = 
	{
		--{ "background", 1 },
		
		--{ "objects", 5 },

		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		move_timer_spec,
		flo_spec, -- the main actor
		
		scene_setup,
	};
};
